/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.CallbackThreadInitializer;
import com.sun.jna.FromNativeContext;
import com.sun.jna.FunctionResultContext$CallbackResultContext;
import com.sun.jna.Klass$JNIEnv;
import com.sun.jna.StructureWriteContext$MethodResultContext;
import com.sun.jna.Union$PointerType;
import com.sun.jna.WString;
import com.sun.jna.WeakMemoryHolder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import melotr.MCDAClientWindowHelper;
import melotr.MCDARichHelper;

class ELFAnalyser {
    private boolean _64Bit = false;
    private boolean ELF = false;
    private static final int EI_DATA_BIG_ENDIAN = 2;
    private final String filename;
    private static final int EI_CLASS_64BIT = 2;
    private static final byte[] ELF_MAGIC = new byte[]{127, 69, 76, 70};
    private static final int EF_ARM_ABI_FLOAT_SOFT = 512;
    private boolean arm = false;
    private static final int EF_ARM_ABI_FLOAT_HARD = 1024;
    private static final int E_MACHINE_ARM = 40;
    private boolean armHardFloatFlag = false;
    private boolean armSoftFloatFlag = false;
    private boolean bigEndian = false;
    private boolean armEabiAapcsVfp = false;

    public boolean isArmHardFloat() {
        return this.isArmEabiAapcsVfp() || this.isArmHardFloatFlag();
    }

    private static /* synthetic */ BigInteger readULEB128(ByteBuffer buffer) {
        BigInteger result = BigInteger.ZERO;
        int shift = 0;
        while (true) {
            byte b = buffer.get();
            result = result.or(BigInteger.valueOf(b & 0x7F).shiftLeft(shift));
            if ((b & 0x80) == 0) break;
            shift += 7;
        }
        return result;
    }

    private static /* synthetic */ Map<Integer, Map<ArmAeabiAttributesTag, Object>> parseArmAttributes(ByteBuffer bb) {
        byte format = bb.get();
        if (format != 65) {
            return Collections.EMPTY_MAP;
        }
        while (bb.position() < bb.limit()) {
            int posSectionStart = bb.position();
            int sectionLength = bb.getInt();
            if (sectionLength <= 0) break;
            String vendorName = ELFAnalyser.readNTBS(bb, null);
            if (MCDAClientWindowHelper.l(StructureWriteContext$MethodResultContext.u("\ua7b1\ue0ce\u8326\uf1ec\ud6b0")).equals(vendorName)) {
                return ELFAnalyser.parseAEABI(bb);
            }
            ((Buffer)bb).position(posSectionStart + sectionLength);
        }
        return Collections.EMPTY_MAP;
    }

    public boolean isArmEabiAapcsVfp() {
        return this.armEabiAapcsVfp;
    }

    public static ELFAnalyser analyse(String filename) throws IOException {
        ELFAnalyser res = new ELFAnalyser(filename);
        res.runDetection();
        return res;
    }

    public boolean isArmSoftFloatFlag() {
        return this.armSoftFloatFlag;
    }

    public boolean is64Bit() {
        return this._64Bit;
    }

    private static /* synthetic */ Map<Integer, Map<ArmAeabiAttributesTag, Object>> parseAEABI(ByteBuffer buffer) {
        HashMap<Integer, Map<ArmAeabiAttributesTag, Object>> data = new HashMap<Integer, Map<ArmAeabiAttributesTag, Object>>();
        while (buffer.position() < buffer.limit()) {
            int pos = buffer.position();
            int subsectionTag = ELFAnalyser.readULEB128(buffer).intValue();
            int length = buffer.getInt();
            if (subsectionTag == 1) {
                data.put(subsectionTag, ELFAnalyser.parseFileAttribute(buffer));
            }
            ((Buffer)buffer).position(pos + length);
        }
        return data;
    }

    private /* synthetic */ ELFAnalyser(String filename) {
        this.filename = filename;
    }

    public boolean isBigEndian() {
        return this.bigEndian;
    }

    private static /* synthetic */ Map<ArmAeabiAttributesTag, Object> parseFileAttribute(ByteBuffer bb) {
        HashMap<ArmAeabiAttributesTag, Object> result = new HashMap<ArmAeabiAttributesTag, Object>();
        while (bb.position() < bb.limit()) {
            int tagValue = ELFAnalyser.readULEB128(bb).intValue();
            ArmAeabiAttributesTag tag = ArmAeabiAttributesTag.getByValue(tagValue);
            switch (tag.getParameterType()) {
                case UINT32: {
                    result.put(tag, bb.getInt());
                    break;
                }
                case NTBS: {
                    result.put(tag, ELFAnalyser.readNTBS(bb, null));
                    break;
                }
                case ULEB128: {
                    result.put(tag, ELFAnalyser.readULEB128(bb));
                }
            }
        }
        return result;
    }

    private static /* synthetic */ String readNTBS(ByteBuffer buffer, Integer position) {
        byte currentByte;
        if (position != null) {
            ((Buffer)buffer).position(position);
        }
        int startingPos = buffer.position();
        while ((currentByte = buffer.get()) != 0 && buffer.position() <= buffer.limit()) {
        }
        int terminatingPosition = buffer.position();
        byte[] data = new byte[terminatingPosition - startingPos - 1];
        ((Buffer)buffer).position(startingPos);
        buffer.get(data);
        ((Buffer)buffer).position(buffer.position() + 1);
        try {
            return new String(data, WeakMemoryHolder.l(Klass$JNIEnv.n("\u3028\udaee\u5cc3\u5086\u276b")));
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public boolean isArm() {
        return this.arm;
    }

    public String getFilename() {
        return this.filename;
    }

    public boolean isELF() {
        return this.ELF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ void runDetection() throws IOException {
        RandomAccessFile raf = new RandomAccessFile(this.filename, MCDAClientWindowHelper.l(Klass$JNIEnv.n("\ubda4")));
        try {
            if (raf.length() > 4L) {
                byte[] magic = new byte[4];
                raf.seek(0L);
                raf.read(magic);
                if (Arrays.equals(magic, ELF_MAGIC)) {
                    this.ELF = true;
                }
            }
            if (!this.ELF) {
                return;
            }
            raf.seek(4L);
            byte sizeIndicator = raf.readByte();
            byte endianessIndicator = raf.readByte();
            this._64Bit = sizeIndicator == 2;
            this.bigEndian = endianessIndicator == 2;
            raf.seek(0L);
            ByteBuffer headerData = ByteBuffer.allocate(this._64Bit ? 64 : 52);
            raf.getChannel().read(headerData, 0L);
            headerData.order(this.bigEndian ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
            boolean bl = this.arm = headerData.get(18) == 40;
            if (this.arm) {
                int flags = headerData.getInt(this._64Bit ? 48 : 36);
                this.armHardFloatFlag = (flags & 0x400) == 1024;
                this.armSoftFloatFlag = (flags & 0x200) == 512;
                this.parseEabiAapcsVfp(headerData, raf);
            }
        }
        finally {
            try {
                raf.close();
            }
            catch (IOException magic) {}
        }
    }

    public boolean isArmHardFloatFlag() {
        return this.armHardFloatFlag;
    }

    private /* synthetic */ void parseEabiAapcsVfp(ByteBuffer headerData, RandomAccessFile raf) throws IOException {
        ELFSectionHeaders sectionHeaders = new ELFSectionHeaders(this._64Bit, this.bigEndian, headerData, raf);
        for (ELFSectionHeaderEntry eshe : sectionHeaders.getEntries()) {
            if (!WeakMemoryHolder.l(Klass$JNIEnv.n("\uf318\u207f\u52dd\u449b\uab02\u994f\u4dcc\u1b2c\u682b\ue462\u6965\u2c9c\uc5f1\uf66a\u1d04")).equals(eshe.getName())) continue;
            ByteBuffer armAttributesBuffer = ByteBuffer.allocate(eshe.getSize());
            armAttributesBuffer.order(this.bigEndian ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
            raf.getChannel().read(armAttributesBuffer, eshe.getOffset());
            armAttributesBuffer.rewind();
            Map<Integer, Map<ArmAeabiAttributesTag, Object>> armAttributes = ELFAnalyser.parseArmAttributes(armAttributesBuffer);
            Map<ArmAeabiAttributesTag, Object> fileAttributes = armAttributes.get(1);
            if (fileAttributes == null) continue;
            Object abiVFPargValue = fileAttributes.get(ArmAeabiAttributesTag.ABI_VFP_args);
            if (abiVFPargValue instanceof Integer && ((Integer)abiVFPargValue).equals(1)) {
                this.armEabiAapcsVfp = true;
                continue;
            }
            if (!(abiVFPargValue instanceof BigInteger) || ((BigInteger)abiVFPargValue).intValue() != 1) continue;
            this.armEabiAapcsVfp = true;
        }
    }

    static class ArmAeabiAttributesTag {
        public static final ArmAeabiAttributesTag CPU_unaligned_access;
        public static final ArmAeabiAttributesTag CPU_name;
        public static final ArmAeabiAttributesTag ABI_HardFP_use;
        public static final ArmAeabiAttributesTag ABI_PCS_wchar_t;
        public static final ArmAeabiAttributesTag ABI_VFP_args;
        public static final ArmAeabiAttributesTag ABI_FP_denormal;
        public static final ArmAeabiAttributesTag ABI_PCS_GOT_use;
        public static final ArmAeabiAttributesTag ABI_PCS_R9_use;
        public static final ArmAeabiAttributesTag MPextension_use2;
        private final String name;
        public static final ArmAeabiAttributesTag compatibility;
        public static final ArmAeabiAttributesTag DIV_use;
        public static final ArmAeabiAttributesTag ARM_ISA_use;
        public static final ArmAeabiAttributesTag Section;
        private final ParameterType parameterType;
        public static final ArmAeabiAttributesTag Symbol;
        public static final ArmAeabiAttributesTag T2EE_use;
        public static final ArmAeabiAttributesTag ABI_FP_rounding;
        public static final ArmAeabiAttributesTag ABI_PCS_RW_data;
        public static final ArmAeabiAttributesTag also_compatible_with;
        public static final ArmAeabiAttributesTag conformance;
        public static final ArmAeabiAttributesTag THUMB_ISA_use;
        public static final ArmAeabiAttributesTag ABI_enum_size;
        public static final ArmAeabiAttributesTag Virtualization_use;
        private static final Map<String, ArmAeabiAttributesTag> nameMap;
        public static final ArmAeabiAttributesTag Advanced_SIMD_arch;
        public static final ArmAeabiAttributesTag CPU_arch;
        private static final List<ArmAeabiAttributesTag> tags;
        public static final ArmAeabiAttributesTag ABI_FP_number_model;
        public static final ArmAeabiAttributesTag ABI_align8_preserved;
        public static final ArmAeabiAttributesTag FP_HP_extension;
        public static final ArmAeabiAttributesTag ABI_FP_optimization_goals;
        private final int value;
        public static final ArmAeabiAttributesTag WMMX_arch;
        public static final ArmAeabiAttributesTag nodefaults;
        public static final ArmAeabiAttributesTag ABI_FP_exceptions;
        public static final ArmAeabiAttributesTag ABI_FP_user_exceptions;
        public static final ArmAeabiAttributesTag CPU_raw_name;
        public static final ArmAeabiAttributesTag PCS_config;
        public static final ArmAeabiAttributesTag File;
        private static final Map<Integer, ArmAeabiAttributesTag> valueMap;
        public static final ArmAeabiAttributesTag ABI_align_needed;
        public static final ArmAeabiAttributesTag MPextension_use;
        public static final ArmAeabiAttributesTag ABI_FP_16bit_format;
        public static final ArmAeabiAttributesTag ABI_WMMX_args;
        public static final ArmAeabiAttributesTag CPU_arch_profile;
        public static final ArmAeabiAttributesTag FP_arch;
        public static final ArmAeabiAttributesTag ABI_optimization_goals;
        public static final ArmAeabiAttributesTag ABI_PCS_RO_data;

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ArmAeabiAttributesTag other = (ArmAeabiAttributesTag)obj;
            return this.value == other.value;
        }

        static {
            tags = new LinkedList<ArmAeabiAttributesTag>();
            valueMap = new HashMap<Integer, ArmAeabiAttributesTag>();
            nameMap = new HashMap<String, ArmAeabiAttributesTag>();
            File = ArmAeabiAttributesTag.addTag(1, WString.l(FunctionResultContext$CallbackResultContext.p("\ua9e8\ua7cf\u3a51\uc7a7")), ParameterType.UINT32);
            Section = ArmAeabiAttributesTag.addTag(2, CallbackThreadInitializer.l(FunctionResultContext$CallbackResultContext.p("\ua9dd\ua79d\u3a7e\uc7e8\u7f75\ue62b\u0df0")), ParameterType.UINT32);
            Symbol = ArmAeabiAttributesTag.addTag(3, WString.l(FunctionResultContext$CallbackResultContext.p("\ua9fd\ua7df\u3a50\uc7a0\u7f53\ue676")), ParameterType.UINT32);
            CPU_raw_name = ArmAeabiAttributesTag.addTag(4, CallbackThreadInitializer.l(FunctionResultContext$CallbackResultContext.p("\ua9dd\ua7b8\u3a58\uc7d3\u7f7e\ue635\u0df9\ub48d\u2ef3\u4910\uf4a2\u1122")), ParameterType.NTBS);
            CPU_name = ArmAeabiAttributesTag.addTag(5, WString.l(FunctionResultContext$CallbackResultContext.p("\ua9ed\ua7f6\u3a68\uc79d\u7f52\ue67b\u0dd3\ub4f9")), ParameterType.NTBS);
            CPU_arch = ArmAeabiAttributesTag.addTag(6, CallbackThreadInitializer.l(FunctionResultContext$CallbackResultContext.p("\ua9dd\ua7b8\u3a58\uc7d3\u7f6d\ue626\u0ded\ub4ba")), ParameterType.ULEB128);
            CPU_arch_profile = ArmAeabiAttributesTag.addTag(7, WString.l(FunctionResultContext$CallbackResultContext.p("\ua9ed\ua7f6\u3a68\uc79d\u7f5d\ue668\u0ddd\ub4f4\u2ef2\u494f\uf48d\u1166\u31eb\ucd30\uc220\ub47f")), ParameterType.ULEB128);
            ARM_ISA_use = ArmAeabiAttributesTag.addTag(8, CallbackThreadInitializer.l(FunctionResultContext$CallbackResultContext.p("\ua9cf\ua7aa\u3a50\uc7c3\u7f55\ue617\u0ddf\ub49d\u2ef8\u4912\uf4ba")), ParameterType.ULEB128);
            THUMB_ISA_use = ArmAeabiAttributesTag.addTag(9, WString.l(FunctionResultContext$CallbackResultContext.p("\ua994\ua780\u3a06\uc7e1\u7f10\ue62b\u0d99\ub4a1\u2e82\u490e\uf4e4\u1114\u3186")), ParameterType.ULEB128);
            FP_arch = ArmAeabiAttributesTag.addTag(10, CallbackThreadInitializer.l(FunctionResultContext$CallbackResultContext.p("\ua9c8\ua7a8\u3a42\uc7fd\u7f6e\ue627\u0df6")), ParameterType.ULEB128);
            WMMX_arch = ArmAeabiAttributesTag.addTag(11, WString.l(FunctionResultContext$CallbackResultContext.p("\ua997\ua785\u3a1e\uc7f4\u7f0d\ue615\u0da2\ub491\u2eab")), ParameterType.ULEB128);
            Advanced_SIMD_arch = ArmAeabiAttributesTag.addTag(12, CallbackThreadInitializer.l(FunctionResultContext$CallbackResultContext.p("\ua9df\ua78c\u3a7b\uc7ed\u7f62\ue637\u0deb\ub4b6\u2ec2\u4922\uf486\u110a\u31f9\ucd48\uc21d\ub426\uf44e\u43e0")), ParameterType.ULEB128);
            PCS_config = ArmAeabiAttributesTag.addTag(13, WString.l(FunctionResultContext$CallbackResultContext.p("\ua9fe\ua7e5\u3a6e\uc79d\u7f5f\ue675\u0dd0\ub4fa\u2ec4\u4958")), ParameterType.ULEB128);
            ABI_PCS_R9_use = ArmAeabiAttributesTag.addTag(14, CallbackThreadInitializer.l(FunctionResultContext$CallbackResultContext.p("\ua9df\ua7aa\u3a44\uc7d3\u7f5c\ue617\u0ddd\ub48d\u2ecf\u4948\uf490\u1132\u31ce\ucd72")), ParameterType.ULEB128);
            ABI_PCS_RW_data = ArmAeabiAttributesTag.addTag(15, WString.l(FunctionResultContext$CallbackResultContext.p("\ua981\ua78a\u3a1a\uc7f3\u7f02\ue637\u0d83\ub4ad\u2e91\u4906\uf4ce\u1103\u3182\ucd43\uc243")), ParameterType.ULEB128);
            ABI_PCS_RO_data = ArmAeabiAttributesTag.addTag(16, CallbackThreadInitializer.l(FunctionResultContext$CallbackResultContext.p("\ua9cf\ua7ba\u3a54\uc7c3\u7f4c\ue607\u0dcd\ub49d\u2edf\u492e\uf480\u1133\u31cc\ucd73\uc20d")), ParameterType.ULEB128);
            ABI_PCS_GOT_use = ArmAeabiAttributesTag.addTag(17, WString.l(FunctionResultContext$CallbackResultContext.p("\ua981\ua78a\u3a1a\uc7f3\u7f02\ue637\u0d83\ub4ad\u2e84\u491e\uf4c5\u1138\u3196\ucd44\uc247")), ParameterType.ULEB128);
            ABI_PCS_wchar_t = ArmAeabiAttributesTag.addTag(18, CallbackThreadInitializer.l(FunctionResultContext$CallbackResultContext.p("\ua9cf\ua7ba\u3a54\uc7c3\u7f4c\ue607\u0dcd\ub49d\u2efa\u4902\uf4b7\u1136\u31df\ucd58\uc218")), ParameterType.ULEB128);
            ABI_FP_rounding = ArmAeabiAttributesTag.addTag(19, WString.l(FunctionResultContext$CallbackResultContext.p("\ua981\ua78a\u3a1a\uc7f3\u7f14\ue624\u0d8f\ub480\u2eac\u4924\uf4ff\u1103\u318a\ucd59\uc245")), ParameterType.ULEB128);
            ABI_FP_denormal = ArmAeabiAttributesTag.addTag(20, CallbackThreadInitializer.l(FunctionResultContext$CallbackResultContext.p("\ua9cf\ua7ba\u3a54\uc7c3\u7f5a\ue614\u0dc1\ub4a6\u2ee8\u490f\uf4b0\u1125\u31c0\ucd66\uc200")), ParameterType.ULEB128);
            ABI_FP_exceptions = ArmAeabiAttributesTag.addTag(21, WString.l(FunctionResultContext$CallbackResultContext.p("\ua981\ua78a\u3a1a\uc7f3\u7f14\ue624\u0d8f\ub497\u2ebb\u4932\uf4f4\u1117\u3197\ucd5e\uc24d\ub41a\uf400")), ParameterType.ULEB128);
            ABI_FP_user_exceptions = ArmAeabiAttributesTag.addTag(22, CallbackThreadInitializer.l(FunctionResultContext$CallbackResultContext.p("\ua9df\ua7aa\u3a44\uc7d3\u7f4a\ue604\u0dd1\ub4a7\u2eee\u4914\uf4bd\u1118\u31d8\ucd6f\uc21f\ub431\uf45d\u43fc\u332d\u3d1f\uf9bd\ub339")), ParameterType.ULEB128);
            ABI_FP_number_model = ArmAeabiAttributesTag.addTag(23, WString.l(FunctionResultContext$CallbackResultContext.p("\ua981\ua78a\u3a1a\uc7f3\u7f14\ue624\u0d8f\ub49c\u2eb6\u493c\uf4f3\u1102\u3191\ucd68\uc24f\ub41b\uf417\u43cd\u3376")), ParameterType.ULEB128);
            ABI_align_needed = ArmAeabiAttributesTag.addTag(24, CallbackThreadInitializer.l(FunctionResultContext$CallbackResultContext.p("\ua9df\ua7aa\u3a44\uc7d3\u7f6d\ue638\u0de7\ub4b5\u2ef3\u492e\uf4a1\u1122\u31d8\ucd73\uc219\ub430")), ParameterType.ULEB128);
            ABI_align8_preserved = ArmAeabiAttributesTag.addTag(25, WString.l(FunctionResultContext$CallbackResultContext.p("\ua9ef\ua7e4\u3a74\uc79d\u7f5d\ue676\u0dd7\ub4fb\u2ec3\u4907\uf4a0\u1179\u31ff\ucd3c\uc23f\ub47f\uf46f\u43b0\u3311\u3d5a")), ParameterType.ULEB128);
            ABI_enum_size = ArmAeabiAttributesTag.addTag(26, CallbackThreadInitializer.l(FunctionResultContext$CallbackResultContext.p("\ua9cf\ua7ba\u3a54\uc7c3\u7f79\ue62a\u0deb\ub4af\u2ed2\u4912\uf4b6\u112d\u31c8")), ParameterType.ULEB128);
            ABI_HardFP_use = ArmAeabiAttributesTag.addTag(27, WString.l(FunctionResultContext$CallbackResultContext.p("\ua9ef\ua7e4\u3a74\uc79d\u7f74\ue67b\u0dcc\ub4f8\u2eeb\u496f\uf4a0\u117c\u31fe\ucd3c")), ParameterType.ULEB128);
            ABI_VFP_args = ArmAeabiAttributesTag.addTag(28, CallbackThreadInitializer.l(FunctionResultContext$CallbackResultContext.p("\ua9df\ua7aa\u3a44\uc7d3\u7f5a\ue612\u0dde\ub48d\u2efc\u4903\uf4a8\u1134")), ParameterType.ULEB128);
            ABI_WMMX_args = ArmAeabiAttributesTag.addTag(29, WString.l(FunctionResultContext$CallbackResultContext.p("\ua981\ua78a\u3a1a\uc7f3\u7f05\ue639\u0d9d\ub4aa\u2e9c\u4930\uf4e3\u1100\u3190")), ParameterType.ULEB128);
            ABI_optimization_goals = ArmAeabiAttributesTag.addTag(30, CallbackThreadInitializer.l(FunctionResultContext$CallbackResultContext.p("\ua9df\ua7aa\u3a44\uc7d3\u7f63\ue624\u0dfa\ub4bb\u2ef0\u4918\uf4b5\u1126\u31c9\ucd7e\uc213\ub43a\uf472\u43ef\u332b\u3d11\uf9bf\ub339")), ParameterType.ULEB128);
            ABI_FP_optimization_goals = ArmAeabiAttributesTag.addTag(31, WString.l(FunctionResultContext$CallbackResultContext.p("\ua981\ua78a\u3a1a\uc7f3\u7f14\ue624\u0d8f\ub49d\u2eb3\u4925\uf4f8\u110a\u318a\ucd4d\uc243\ub400\uf41a\u43c7\u3374\u3d0f\uf9ea\ub305\u964e\u73ad\udd04")), ParameterType.ULEB128);
            compatibility = ArmAeabiAttributesTag.addTag(32, CallbackThreadInitializer.l(FunctionResultContext$CallbackResultContext.p("\ua9ed\ua797\u3a70\uc7ec\u7f7d\ue630\u0df7\ub4a0\u2ee4\u490d\uf4b6\u1123\u31d4")), ParameterType.NTBS);
            CPU_unaligned_access = ArmAeabiAttributesTag.addTag(34, WString.l(FunctionResultContext$CallbackResultContext.p("\ua9ed\ua7f6\u3a68\uc79d\u7f49\ue674\u0ddf\ub4f0\u2ec4\u4958\uf491\u116c\u31e9\ucd06\uc22d\ub479\uf47e\u43a3\u3307\u3d4d")), ParameterType.ULEB128);
            FP_HP_extension = ArmAeabiAttributesTag.addTag(36, CallbackThreadInitializer.l(FunctionResultContext$CallbackResultContext.p("\ua9c8\ua7a8\u3a42\uc7d4\u7f4c\ue61b\u0dfb\ub4ba\u2ef9\u4904\uf4b1\u1124\u31c4\ucd68\uc202")), ParameterType.ULEB128);
            ABI_FP_16bit_format = ArmAeabiAttributesTag.addTag(38, WString.l(FunctionResultContext$CallbackResultContext.p("\ua981\ua78a\u3a1a\uc7f3\u7f14\ue624\u0d8f\ub4c3\u2ef5\u4933\uf4f8\u1113\u31bc\ucd51\uc24d\ub406\uf41e\u43c9\u336e")), ParameterType.ULEB128);
            MPextension_use = ArmAeabiAttributesTag.addTag(42, CallbackThreadInitializer.l(FunctionResultContext$CallbackResultContext.p("\ua9c3\ua7a8\u3a78\uc7e4\u7f68\ue621\u0df0\ub4b1\u2ee4\u490e\uf4b1\u1108\u31d8\ucd74\uc209")), ParameterType.ULEB128);
            DIV_use = ArmAeabiAttributesTag.addTag(44, WString.l(FunctionResultContext$CallbackResultContext.p("\ua984\ua781\u3a05\uc7f3\u7f27\ue607\u0db5")), ParameterType.ULEB128);
            nodefaults = ArmAeabiAttributesTag.addTag(64, CallbackThreadInitializer.l(FunctionResultContext$CallbackResultContext.p("\ua9f0\ua787\u3a69\uc7e9\u7f6a\ue635\u0dfb\ub4be\u2ee9\u4902")), ParameterType.ULEB128);
            also_compatible_with = ArmAeabiAttributesTag.addTag(65, WString.l(FunctionResultContext$CallbackResultContext.p("\ua9cf\ua7ca\u3a4e\uc7ad\u7f63\ue679\u0dd1\ub4f1\u2edd\u495e\uf48b\u1160\u31ef\ucd35\uc229\ub445\uf46a\u43af\u3300\u3d56")), ParameterType.NTBS);
            conformance = ArmAeabiAttributesTag.addTag(67, CallbackThreadInitializer.l(FunctionResultContext$CallbackResultContext.p("\ua9ed\ua797\u3a73\uc7fa\u7f73\ue636\u0df3\ub4a3\u2ee3\u4902\uf4ba")), ParameterType.NTBS);
            T2EE_use = ArmAeabiAttributesTag.addTag(66, WString.l(FunctionResultContext$CallbackResultContext.p("\ua9fa\ua794\u3a78\uc787\u7f63\ue66f\u0dcd\ub4f9")), ParameterType.ULEB128);
            Virtualization_use = ArmAeabiAttributesTag.addTag(68, CallbackThreadInitializer.l(FunctionResultContext$CallbackResultContext.p("\ua9c8\ua781\u3a7f\uc7f8\u7f79\ue635\u0de2\ub4bb\u2ee7\u4910\uf4bb\u112e\u31d2\ucd79\uc223\ub421\uf45e\u43ed")), ParameterType.ULEB128);
            MPextension_use2 = ArmAeabiAttributesTag.addTag(70, WString.l(FunctionResultContext$CallbackResultContext.p("\ua98d\ua798\u3a36\uc7d4\u7f26\ue611\u0dbe\ub481\u2eaa\u493e\uf4ff\u1138\u3196\ucd44\uc247")), ParameterType.ULEB128);
        }

        public static ArmAeabiAttributesTag getByName(String name) {
            return nameMap.get(name);
        }

        private static /* synthetic */ ArmAeabiAttributesTag addTag(int value, String name, ParameterType type) {
            ArmAeabiAttributesTag tag = new ArmAeabiAttributesTag(value, name, type);
            if (!valueMap.containsKey(tag.getValue())) {
                valueMap.put(tag.getValue(), tag);
            }
            if (!nameMap.containsKey(tag.getName())) {
                nameMap.put(tag.getName(), tag);
            }
            tags.add(tag);
            return tag;
        }

        public int hashCode() {
            int hash = 7;
            hash = 67 * hash + this.value;
            return hash;
        }

        public ParameterType getParameterType() {
            return this.parameterType;
        }

        public ArmAeabiAttributesTag(int value, String name, ParameterType parameterType) {
            this.value = value;
            this.name = name;
            this.parameterType = parameterType;
        }

        public static ArmAeabiAttributesTag getByValue(int value) {
            if (valueMap.containsKey(value)) {
                return valueMap.get(value);
            }
            ArmAeabiAttributesTag pseudoTag = new ArmAeabiAttributesTag(value, CallbackThreadInitializer.l(FunctionResultContext$CallbackResultContext.p("\uba9e\u35ab\uf57a\ud8f1\u27d2\u1bef\u0212\u1bf5")) + value, ArmAeabiAttributesTag.getParameterType(value));
            return pseudoTag;
        }

        public int getValue() {
            return this.value;
        }

        public String getName() {
            return this.name;
        }

        public static List<ArmAeabiAttributesTag> getTags() {
            return Collections.unmodifiableList(tags);
        }

        private static /* synthetic */ ParameterType getParameterType(int value) {
            ArmAeabiAttributesTag tag = ArmAeabiAttributesTag.getByValue(value);
            if (tag == null) {
                if (value % 2 == 0) {
                    return ParameterType.ULEB128;
                }
                return ParameterType.NTBS;
            }
            return tag.getParameterType();
        }

        public String toString() {
            return this.name + WString.l(Union$PointerType.H("\ued0f\uaf6f")) + this.value + CallbackThreadInitializer.l(Union$PointerType.H("\ued26"));
        }

        public static enum ParameterType {
            UINT32,
            NTBS,
            ULEB128;

        }
    }

    static class ELFSectionHeaderEntry {
        private String name;
        private final int size;
        private final int offset;
        private final int flags;
        private final int nameOffset;
        private final int type;

        public int getType() {
            return this.type;
        }

        public ELFSectionHeaderEntry(boolean _64bit, ByteBuffer sectionHeaderData) {
            this.nameOffset = sectionHeaderData.getInt(0);
            this.type = sectionHeaderData.getInt(4);
            this.flags = (int)(_64bit ? sectionHeaderData.getLong(8) : (long)sectionHeaderData.getInt(8));
            this.offset = (int)(_64bit ? sectionHeaderData.getLong(24) : (long)sectionHeaderData.getInt(16));
            this.size = (int)(_64bit ? sectionHeaderData.getLong(32) : (long)sectionHeaderData.getInt(20));
        }

        public int getSize() {
            return this.size;
        }

        public int getFlags() {
            return this.flags;
        }

        public String toString() {
            return MCDARichHelper.l(Union$PointerType.H("\u886b\u5605\u66f1\u20a9\ub685\u5dd8\u074b\u826a\u5ea0\u0c6a\u9e8d\ub52d\u26e0\u1f8c\u8e3d\u9d17\ud0e2\u5566\u6e5d\u532a\u127b\uef27\u7242\ubcbc\u872f\u9210\u7a38\u09c1\u76e3\u2e44")) + this.nameOffset + WeakMemoryHolder.l(Union$PointerType.H("\u884c\u5603\u6697\u20f1\ub6c3\u5db4\u074c")) + this.name + MCDARichHelper.l(Union$PointerType.H("\u8871\u561a\u66b0\u20f0\ub6e3\u5dad\u0771")) + this.type + WeakMemoryHolder.l(Union$PointerType.H("\u881b\u5654\u66c8\u20ab\ub698\u5de1\u0755\u8203")) + this.flags + MCDARichHelper.l(Union$PointerType.H("\u8871\u561a\u66ab\u20ef\ub6f5\u5dbb\u0729\u8204\u5e81")) + this.offset + WeakMemoryHolder.l(Union$PointerType.H("\u884c\u5603\u668a\u20f9\ub6d4\u5db4\u074c")) + this.size + '}';
        }

        public int getOffset() {
            return this.offset;
        }

        public int getNameOffset() {
            return this.nameOffset;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    static class ELFSectionHeaders {
        private final List<ELFSectionHeaderEntry> entries = new ArrayList<ELFSectionHeaderEntry>();

        public List<ELFSectionHeaderEntry> getEntries() {
            return this.entries;
        }

        public ELFSectionHeaders(boolean _64bit, boolean bigEndian, ByteBuffer headerData, RandomAccessFile raf) throws IOException {
            short shstrndx;
            int shnum;
            short shentsize;
            long shoff;
            if (_64bit) {
                shoff = headerData.getLong(40);
                shentsize = headerData.getShort(58);
                shnum = headerData.getShort(60);
                shstrndx = headerData.getShort(62);
            } else {
                shoff = headerData.getInt(32);
                shentsize = headerData.getShort(46);
                shnum = headerData.getShort(48);
                shstrndx = headerData.getShort(50);
            }
            int tableLength = shnum * shentsize;
            ByteBuffer data = ByteBuffer.allocate(tableLength);
            data.order(bigEndian ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
            raf.getChannel().read(data, shoff);
            for (int i = 0; i < shnum; ++i) {
                data.position(i * shentsize);
                ByteBuffer header = data.slice();
                header.order(data.order());
                header.limit(shentsize);
                this.entries.add(new ELFSectionHeaderEntry(_64bit, header));
            }
            ELFSectionHeaderEntry stringTable = this.entries.get(shstrndx);
            ByteBuffer stringBuffer = ByteBuffer.allocate(stringTable.getSize());
            stringBuffer.order(bigEndian ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
            raf.getChannel().read(stringBuffer, stringTable.getOffset());
            stringBuffer.rewind();
            ByteArrayOutputStream baos = new ByteArrayOutputStream(20);
            for (ELFSectionHeaderEntry eshe : this.entries) {
                byte b;
                baos.reset();
                ((Buffer)stringBuffer).position(eshe.getNameOffset());
                while (stringBuffer.position() < stringBuffer.limit() && (b = stringBuffer.get()) != 0) {
                    baos.write(b);
                }
                eshe.setName(baos.toString(FromNativeContext.l(StructureWriteContext$MethodResultContext.u("\u878c\u08c8\u927a\uebc7\uefad"))));
            }
        }
    }
}

